import constraint

problem = constraint.Problem()
# Definisemo promenljive i njihove vrednosti
problem.addVariable('A',range(1,10))
problem.addVariable('B',range(10))
problem.addVariable('C',range(10))
problem.addVariable('D',range(10))
problem.addVariable('E',range(10))
# Dodajemo ogranicenje da su vrednosti svih promenljivih razlicite
problem.addConstraint(constraint.AllDifferentConstraint())
resenja = problem.getSolutions()
# Znamo da minimalna vrednost izraza A+2*B-3*C+4*D-5*E 
# mora biti sigurno manja od 63 (za A,B,D najvece, a C i D najmanje vrednosti za cifre)
min_izraz = 63
min_resenje = {}
for resenje in resenja:
    a = resenje['A']
    b = resenje['B']
    c = resenje['C']
    d = resenje['D']
    e = resenje['E']
    izraz = a+2*b-3*c+4*d-5*e
    if izraz < min_izraz:
        min_izraz = izraz
        min_resenje = resenje
# formiramo petocifren broj na osnovu odredjenog resenja
print(min_resenje['A']*10000 + min_resenje['B']*1000 + min_resenje['C']*100 
                             + min_resenje['D']*10 + min_resenje['E'])
