# za testiranje za pripremljenu datoteku: 
# python3 21.py Engleska fudbaleri.json
from sys import argv
import json 
from functools import cmp_to_key

if len(argv) != 3:
    print("Greska")
    exit(1)

nacionalnost = argv[1]
datoteka = argv[2]

try:
    with open(datoteka, "r") as f:
        fudbaleri = json.load(f)
except IOError:
    print("Greska")
    exit(1)

# print(fudbaleri)

# verzija bez lambde
def uporedi2(x, y):
    if x["Golovi"] > y["Golovi"]:  # 1  0 
        return 1
    elif x["Golovi"] < y["Golovi"]:  # 0  1 
        return -1
    else:
        return 0

# False - True  -1
# True - False   1
# False - False  0
uporedi = lambda x, y: (x["Golovi"] > y["Golovi"]) - (x["Golovi"] < y["Golovi"])
# test za lambdu
# print(uporedi(fudbaleri[3], fudbaleri[2]))

izdvojeni = list(filter(lambda x: x["Nacionalnost"] == nacionalnost, fudbaleri))
# test za filter
# print(izdvojeni)

# cmp_to_key iz modula functools koristimo kako bismo svoju 
# funkciju za poredjenje prosledili preko kljuca key 
rezultat = sorted(izdvojeni, key = cmp_to_key(uporedi))

# direktno pomocu nase funkcije kljuca
# rezultat = sorted(izdvojeni, key = lambda x: x["Golovi"])
print(rezultat)

# upis json objekta u fajl
with open(nacionalnost+"_nacionalnost.json", "w") as f:
    json.dump(rezultat, f)
