{-
  Uparivanje sablona (pattern matching)

  not :: Bool -> Bool
  not True = False
  not False = True

  Ako pozovemo not True uparice se prvi sablon,
  a ako pozovemo not False uparice se drugi sablon

  Dzoker (wildcard)

  prvi nacin (ako bismo zamenili redosled sablona, javlja pattern match overlapped)
  (&&) :: Bool -> Bool -> Bool
  True && True = True
  _ && _ = False   --- moglo bi i: n && m = False, bitno je samo da su razlicito imenovani

  drugi nacin, efikasniji:
  (&&) :: Bool -> Bool -> Bool
  True && x = x
  False && _ = False

  _ predstavlja dzoker, tj. sablon koji odgovara bilo kojoj vrednosti (obratiti paznju na redosled definisanja sablona!)

  Sabloni lista:

  length [_] = 1 - [_] predstavlja listu sa jednim elementom
  length x = 1 + length (tail x) - x predstavlja listu

-}

length1 [] = 0
length1 x = 1 + length1 (tail x)

-- (x:xs) - predstavlja sablon liste, x je glava, xs je rep

length2 [] = 0
length2 (_:xs) = 1 + length2 xs
