import Data.List 

{-
    funkcija sort iz Data.List 
    rastuce sortira listu elemenata 
    pomocu funkcije compare 
    koja za povratnu vrednost ima instancu 
    klase Ordering
-}
sortiraj :: Ord a => [a] -> [a]
sortiraj = sort 

{-
    funkcija sortBy kao argument ocekuje 
    funkciju za sortiranje 
    u slucaju da zelimo da sortiramo opadajuce
    mozemo iskoristiti funkciju flip za zamenu 
    argumenata koji se prosledjuju funkciji compare
    i na taj nacin postici sortiranje u obrnutom redosledu
-}
sortiraj2 :: Ord a => [a] -> [a]
sortiraj2 = sortBy (flip compare) 

-- kako bismo sortirali listu parova po drugom elementu para
-- prosledjujemo funkciju za poredjenje 
-- koja iz para izdvaja drugi element 
-- iz njih poredi pomocu funkcije compare
-- korisnicka funkcija za poredjenje mora 
-- kao povratnu vrednost imati instancu klase Ordering 
sortiraj3 :: Ord a => [(a,a)] -> [(a,a)]
sortiraj3 = sortBy poredi 

poredi :: Ord a => (a,a) -> (a,a) -> Ordering 
poredi a b = compare (snd a) (snd b)

-- kako bismo sortirali opadajuce po drugom elementu para 
-- mozemo iskoristiti funkciju sortOn 
-- koja kao argument ocekuje funkciju kljuca koja se 
-- primenjuje nad elementima liste 
-- nakon cega se rezultat primene funkcije koristi pri poredjenju 


-- sortOn je uvedena od verzije 4.8.0.0 (izvor: https://hackage.haskell.org/package/base-4.8.1.0/docs/Data-List.html#v:sortOn)
-- sortiranje raditi pomocu sort i sortBy funkcije ako je starija verzija platforme 
-- ili uraditi upgrade sistema
-- sortiraj4 :: (Ord a, Num a) => [(a,a)] -> [(a,a)]
-- sortiraj4 = sortOn (negate . snd)

-- kompozicija negate i snd funkcije
-- transformise parove na sledeci nacin:
-- (a,b) -> -b 
-- ako se iskoristi da: a < b -> -a > -b 
-- funkcija kljuca parove transformise tako 
-- da ce se funkcijom compare sortirati 
-- u obrnutom poretku, tj. opadajuce 