-- tip Trougao sa parametrima
data Trougao a b c = Jednakostranicni a
	| Jednakokraki a b
	| Raznostranicni a b c
	deriving 
	(Show,   -- ukljucivanje u tipski razred Show, daje mogucnost ispisa instanci 
	Eq,			 -- mogu se koristiti operatori == i /= 
	Ord)		 -- mogu se koristiti relacioni operatori 

-- > Jednakostanicni 5   -- posto je ukljucen tip u tipski razred Show, obezbedjen je print
-- pravilo ispisa: naziv tipa se ispisuje u String reprezentaciji
-- nad svakim parametrom se primenjuje funkcija show, pa je uslov da i svi parametri 
-- pripadaju tipskom razredu Show 

-- primer:  Jednakokraki 2 4 == Jednakokraki 2 5   (False)
-- poredjenje sa == i /= se svodi na poredjenje konstruktora, a ako to poredjenje prodje, 
-- porede se parametri po parovima

-- primer: Jednakostranicni 3 < Raznostranicni 3 4 5   (True)
-- poredjenje relacionim operatorima se svodi na poredjenje konstruktora, 
-- ukoliko su isti, relaciono se porede parovi parametara
-- ukoliko su razliciti konstruktori, primenjuje se pravilo da je instanca 
-- napravljena ranije deklarisanim konstruktorom uvek manja od instance 
-- napravljena konstruktorom koji je kasnije deklarisan

obim :: Trougao Float Float Float -> Float
obim (Jednakostranicni a ) = 3*a
obim (Jednakokraki a b ) = 2*a + b
obim (Raznostranicni a b c ) = a + b + c

-- primer: obim (Jednakostranicni 5)

listaTrougao :: [Float] -> [Trougao Float Float Float]
listaTrougao lista = map Jednakostranicni lista

-- svaki konstruktor je u stvari funkcija sa nula ili vise parametara
-- sto se moze proveriti naredbom :t u interpreteru (type signature)
-- :t Jednakostranicni 
-- Jednakostranicni :: a -> Trougao a b c
