-- definisemo nove tipove
-- piksel se predstavlja kao uredjen par
type Pos = (Int, Int)
-- slika se predstavlja kao preslikavanje koje za piksel vraca True ili False u zavisnosti da li je piksel ukljucen na toj slici
type Pic = Pos -> Bool

-- a)
-- funkcija predstavlja sliku gde nije ukljucen nijedan piksel , odnosno to je preslikavanje koje za svaki piksel vraca False  
empty :: Pic
empty p = False
-- funkcija predstavlja sliku gde su ukljuceni svi pikseli, odnosno to je preslikavanje koje za svaki piksel vraca True  
full :: Pic
full p = True
-- funkcija kao vrednost ima sliku, tj. funkciju koja samo za dati piksel vraca True, a za svaki ostali False
only :: Pos -> Pic
only p = \x -> if x == p then True else False

-- b)
-- inverz slike -> invertujemo ukljucene/iskljucene piskele
inverse :: Pic -> Pic
inverse f p = not (f p)
-- uniramo ukljucene piskele
union :: Pic -> Pic -> Pic
union f f' p = (f p) || (f' p)
-- pravimo presek ukljucenih piksela
intersect :: Pic -> Pic -> Pic
intersect f f' p = (f p) && (f' p)

-- c)
-- za svaki piksel proveravamo da li ukljucen ili ne u sliku
render :: Pic -> [[Bool]]
-- elementi su liste, za jednu listu je fiksirana x koordinata, a y ide od 0 do 4
render p = [[p (x,y) | y <- [0..4]] | x <- [0..4]]

-- d)
-- vracamo vrednost iz liste listi koja odgovara pikselu (x,y) -> ta vrednost se nalazi na poziciji y u x-toj listi   
extract :: [[Bool]] -> Pic
extract l (x,y) = l !! x !! y
