/*
Lista - niz uredjenih elemenata, tj. termova.
Lista moze biti:
	[] - prazna 
	.(G,R) - struktura, gde je G ma koji term i naziva se glava liste, a R lista i naziva se rep liste

Primeri:
	[] - prazna
	.(a, []) - jednoclana lista, gde je a bilo koji term 
	.(a, .(b, [])) - dvoclana lista, gde su a i b termi ...

Zapis pomocu zagrada (prvi element predstavlja glavu, a ostali cine listu koja je rep):
	[a,b,c] <=> .(a, .(b, [c])) 

Zapis liste u kom su jasno razdvojeni glava i rep (pogodan za unifikaciju): [G|R].

Primeri unifikacije listi:
[X, Y, Z]	[jabuka, kruska, banana]  -----> X = jabuka, Y = kruska, Z = banana
[racunar]	[X|Y]                     -----> X = racunar, Y = []
[maja, ana, jovana]	[X, Y|Z]          -----> X = maja, Y = ana, Z = [jovana]	  
	
*/

% primeri predikata za rad sa listama
% predikat proverava da li element pripada listi (ako joj pripada jednak je glavi ili nekom elementu iz repa liste)
sadrzi(X, [X|_]):- !.
sadrzi(X, [G|R]):- G \== X, sadrzi(X, R).

% drugi nacin, predikat kao disjunkcija:
% sadrzi(X, [G|R]):- G == X; sadrzi(X, R).

% postoji i ugradjeni predikat length(Lista,DuzinaListe)
% predikat koji racuna duzinu liste (prazna je duzine nula, nepraznu dekomponujemo na glavu i rep, pa je duzina liste = 1 + duzina repa)
duzina([], 0).
duzina([G|R], L):- duzina(R,L1), L is L1+1. 

% predikat racuna sumu elemenata liste brojeva
% predikat number proverava da li je zadati term broj
% u slucaju da se zada lista sa bar jednim elementom koji nije broj
% upit vraca odgovor no jer ce predikat biti netacan
suma([], 0).
suma([G|R], S):- number(G), suma(R, S1), S is S1+G.

% predikat racuna aritmeticku sredinu elemenata liste brojeva
arsr([],0).
% ako ne koristimo sablon za nepraznu listu [G|R], moramo proveriti da li je K nula jer se sada L moze unifikovati sa []
arsr(L, A):- duzina(L, K), K =\= 0, suma(L, S), A is S/K. 
% ako upotrebimo cut operator u slucaju prazne liste, ne mora se proveravati slucaj K jednako 0

